;
;								EJEMPLO 8
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;Juego de luces, otra temporizacin.
;
;Se desea realiza una rotacin secuencial en el encendido de cada led contectados a la
;puerta B del laboratorio PIC'School. Si RA0 = 0, la rotacin ser de derecha a izquierda 
;y viceversa. Cada led permanece encendido 0.25 segundos (250 mS)
	
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdig y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC


Contador		equ		0x20	;Variable para la temporizacin
                    
				org		0x00	
				goto	Inicio	;Vector de reset
				org		0x05

;***************************************************************************************
;Delay es una rutina que realiza una temporizacin de 250 mS que es el tiempo en que han
;de permanecer encendido cada uno de los leds. Consiste en repetir 25 veces la temporizacin
;de 10mS que se emple en el ejercicio anterior.

Delay		movlw	.25
			movwf	Contador	;Carga el contador con 25
Delay_0		bcf		INTCON,T0IF	;Desconecta el flag de rebosamiento del TMR0
			movlw	~.39
			movwf	TMR0		;carga el TMR0 con 39
Delay_1		btfss	INTCON,T0IF	;Rebasamiento del TMR0 ??
			goto	Delay_1		;No.Todava no han pasado los 10 mS
			decfsz	Contador,F	;Decrementa contador. Se ha repetido 25 veces ?
			goto	Delay_0		;Todava no, temporiza otros 10 ms
			return				;Ahora si

Inicio	    clrf 	PORTB		;Borra los latch de salida
			bsf		STATUS,RP0	;Selecciona banco 1
			clrf	TRISB		;Puerta B se configura como salida
			movlw	0x06
			movwf	ADCON1		;Puerta A digital
			movlw	b'00011111'	
			movwf	TRISA		;Puerta A se configura como entrada
			movlw	b'00000111'
			movwf	OPTION_REG	;Preescaler de 256 para el TMR0
			bcf		STATUS,RP0	;Selecciona banco 0			                                                                         
	
			bsf		STATUS,C	;Activa el carry
Loop		call	Delay		;Temporiza 250mS
			btfsc	PORTA,0		;Est a 0 RA0 ??
			goto	A_Dcha		;No, rotacin a derecha
A_Izda		rlf		PORTB,F		;Si, rotacin a izquierda
			goto	Loop
A_Dcha		rrf		PORTB,F		;Rotacin a derecha
			goto	Loop
	
			end					;Fin del programa fuente
